const mongoose = require('mongoose');

const orderSchema = new mongoose.Schema({
    orderId: {
        type: String,
        unique: true,
        required: true
    },
    userId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User'
    },
    items: [{
        foodId: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'Food'
        },
        name: String,
        quantity: Number,
        price: Number,
        prepTime: Number
    }],
    totalAmount: {
        type: Number,
        required: true
    },
    deliveryCharge: {
        type: Number,
        default: 0
    },
    status: {
        type: String,
        enum: ['pending', 'preparing', 'ready', 'delivered', 'cancelled'],
        default: 'pending'
    },
    estimatedTime: {
        type: Number, // in minutes
        required: true
    },
    actualDeliveryTime: Date,
    customerInfo: {
        name: String,
        email: String,
        phone: String,
        address: String
    },
    paymentMethod: {
        type: String,
        enum: ['cash', 'card', 'crypto'],
        default: 'cash'
    },
    paymentStatus: {
        type: String,
        enum: ['pending', 'completed', 'failed'],
        default: 'pending'
    },
    createdAt: {
        type: Date,
        default: Date.now
    }
});

// Generate order ID
orderSchema.pre('save', function(next) {
    if (!this.orderId) {
        this.orderId = 'ORD' + Date.now() + Math.random().toString(36).substr(2, 9);
    }
    next();
});

module.exports = mongoose.model('Order', orderSchema);