const mongoose = require('mongoose');

const settingsSchema = new mongoose.Schema({
    restaurantName: {
        type: String,
        default: 'NEOBITE'
    },
    logo: String,
    primaryColor: {
        type: String,
        default: '#00f3ff'
    },
    secondaryColor: {
        type: String,
        default: '#ff00ff'
    },
    theme: {
        type: String,
        enum: ['cyberpunk', 'dark', 'light'],
        default: 'cyberpunk'
    },
    header: {
        menuItems: [{
            name: String,
            link: String,
            order: Number
        }],
        ctaButtons: [{
            text: String,
            link: String,
            type: String // primary/secondary
        }]
    },
    heroSection: {
        title: String,
        subtitle: String,
        videoUrl: String,
        buttonText: String
    },
    sectionOrder: [String],
    contactFormFields: [{
        name: String,
        type: String,
        required: Boolean,
        placeholder: String
    }],
    socialLinks: [{
        platform: String,
        url: String,
        icon: String
    }],
    deliveryCharges: {
        type: Number,
        default: 5
    },
    taxRate: {
        type: Number,
        default: 0.1 // 10%
    }
});

module.exports = mongoose.model('Settings', settingsSchema);