const express = require('express');
const router = express.Router();
const multer = require('multer');
const path = require('path');

// Configure storage
const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null, 'uploads/');
    },
    filename: function (req, file, cb) {
        cb(null, Date.now() + path.extname(file.originalname));
    }
});

const upload = multer({ storage });

// Upload logo
router.post('/logo', upload.single('logo'), (req, res) => {
    try {
        if (!req.file) {
            return res.status(400).json({ error: 'No file uploaded' });
        }
        
        res.json({
            url: '/uploads/' + req.file.filename,
            filename: req.file.filename
        });
    } catch (error) {
        res.status(500).json({ error: 'Error uploading file' });
    }
});

// Upload multiple images
router.post('/gallery', upload.array('images', 10), (req, res) => {
    try {
        const urls = req.files.map(file => ({
            url: '/uploads/' + file.filename,
            filename: file.filename
        }));
        
        res.json({ urls });
    } catch (error) {
        res.status(500).json({ error: 'Error uploading images' });
    }
});

// Upload user avatar
router.post('/avatar', upload.single('avatar'), (req, res) => {
    try {
        if (!req.file) {
            return res.status(400).json({ error: 'No file uploaded' });
        }
        
        res.json({
            url: '/uploads/' + req.file.filename
        });
    } catch (error) {
        res.status(500).json({ error: 'Error uploading avatar' });
    }
});

module.exports = router;